/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.handlers;

import com.tiviacz.pizzacraft.client.DynamicPizzaSliceModel;
import com.tiviacz.pizzacraft.client.PizzaBakedModel;
import com.tiviacz.pizzacraft.client.renderer.BasinRenderer;
import com.tiviacz.pizzacraft.client.renderer.ChefHatModel;
import com.tiviacz.pizzacraft.client.renderer.PizzaDeliveryCapModel;
import com.tiviacz.pizzacraft.init.ModBlocks;
import com.tiviacz.pizzacraft.init.PizzaLayers;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="pizzacraft", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientEventHandler {
    @SubscribeEvent
    public static void registerModels(ModelEvent.RegisterGeometryLoaders event) {
        event.register("pizza_slice_loader", (IGeometryLoader)DynamicPizzaSliceModel.Loader.INSTANCE);
    }

    @SubscribeEvent
    public static void layerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BasinRenderer.ContentModel.CONTENT_LAYER, BasinRenderer.ContentModel::createModelData);
        event.registerLayerDefinition(BasinRenderer.SauceModel.SAUCE_LAYER, BasinRenderer.SauceModel::createModelData);
        event.registerLayerDefinition(PizzaDeliveryCapModel.CAP, PizzaDeliveryCapModel::createModelData);
        event.registerLayerDefinition(ChefHatModel.CHEF_HAT, ChefHatModel::createModelData);
    }

    @SubscribeEvent
    public static void onModelBakeEvent(ModelEvent.BakingCompleted event) {
        PizzaBakedModel customModel;
        BakedModel existingModel;
        ModelResourceLocation variantMRL;
        for (BlockState blockState : ((Block)ModBlocks.PIZZA.get()).m_49965_().m_61056_()) {
            variantMRL = BlockModelShaper.m_110895_((BlockState)blockState);
            existingModel = (BakedModel)event.getModels().get(variantMRL);
            if (existingModel == null || existingModel instanceof PizzaBakedModel) continue;
            customModel = new PizzaBakedModel(existingModel);
            event.getModels().put(variantMRL, customModel);
        }
        for (BlockState blockState : ((Block)ModBlocks.RAW_PIZZA.get()).m_49965_().m_61056_()) {
            variantMRL = BlockModelShaper.m_110895_((BlockState)blockState);
            existingModel = (BakedModel)event.getModels().get(variantMRL);
            if (existingModel == null || existingModel instanceof PizzaBakedModel) continue;
            customModel = new PizzaBakedModel(existingModel);
            event.getModels().put(variantMRL, customModel);
        }
    }

    @SubscribeEvent
    public static void stitcherEventPre(TextureStitchEvent.Pre event) {
        if (event.getAtlas().m_118330_() == InventoryMenu.f_39692_) {
            event.addSprite(PizzaLayers.PIZZA_SLICE);
            event.addSprite(PizzaLayers.CHEESE_LAYER);
            event.addSprite(PizzaLayers.RAW_CHEESE_LAYER);
            event.addSprite(PizzaLayers.BROCCOLI_LAYER);
            event.addSprite(PizzaLayers.CORN_LAYER);
            event.addSprite(PizzaLayers.CUCUMBER_LAYER);
            event.addSprite(PizzaLayers.ONION_LAYER);
            event.addSprite(PizzaLayers.PEPPER_LAYER);
            event.addSprite(PizzaLayers.TOMATO_LAYER);
            event.addSprite(PizzaLayers.RAW_BROCCOLI_LAYER);
            event.addSprite(PizzaLayers.RAW_CORN_LAYER);
            event.addSprite(PizzaLayers.RAW_CUCUMBER_LAYER);
            event.addSprite(PizzaLayers.RAW_ONION_LAYER);
            event.addSprite(PizzaLayers.RAW_PEPPER_LAYER);
            event.addSprite(PizzaLayers.RAW_TOMATO_LAYER);
            event.addSprite(PizzaLayers.BROCCOLI_ITEM_LAYER);
            event.addSprite(PizzaLayers.CORN_ITEM_LAYER);
            event.addSprite(PizzaLayers.CUCUMBER_ITEM_LAYER);
            event.addSprite(PizzaLayers.ONION_ITEM_LAYER);
            event.addSprite(PizzaLayers.PEPPER_ITEM_LAYER);
            event.addSprite(PizzaLayers.TOMATO_ITEM_LAYER);
            event.addSprite(PizzaLayers.PINEAPPLE_LAYER);
            event.addSprite(PizzaLayers.OLIVE_LAYER);
            event.addSprite(PizzaLayers.RAW_PINEAPPLE_LAYER);
            event.addSprite(PizzaLayers.RAW_OLIVE_LAYER);
            event.addSprite(PizzaLayers.PINEAPPLE_ITEM_LAYER);
            event.addSprite(PizzaLayers.OLIVE_ITEM_LAYER);
            event.addSprite(PizzaLayers.MUSHROOM_LAYER);
            event.addSprite(PizzaLayers.RAW_MUSHROOM_LAYER);
            event.addSprite(PizzaLayers.MUSHROOM_ITEM_LAYER);
            event.addSprite(PizzaLayers.HAM_LAYER);
            event.addSprite(PizzaLayers.BEEF_LAYER);
            event.addSprite(PizzaLayers.CHICKEN_LAYER);
            event.addSprite(PizzaLayers.RAW_HAM_LAYER);
            event.addSprite(PizzaLayers.RAW_BEEF_LAYER);
            event.addSprite(PizzaLayers.RAW_CHICKEN_LAYER);
            event.addSprite(PizzaLayers.HAM_ITEM_LAYER);
            event.addSprite(PizzaLayers.BEEF_ITEM_LAYER);
            event.addSprite(PizzaLayers.CHICKEN_ITEM_LAYER);
            event.addSprite(PizzaLayers.TOMATO_SAUCE_LAYER);
            event.addSprite(PizzaLayers.TOMATO_SAUCE_ITEM_LAYER);
        }
    }
}

